<?php $__env->startSection('title', 'الخدمات'); ?>
<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <style>
        .switch {
            position: relative;
            display: inline-block;
            width: 46px;
            height: 24px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #dc3545;
            -webkit-transition: .4s;
            transition: .4s;
            border-radius: 24px;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 18px;
            width: 18px;
            left: 3px;
            bottom: 3px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
            border-radius: 50%;
        }

        input:checked + .slider {
            background-color: #28a745;
        }

        input:checked + .slider:before {
            transform: translateX(22px);
        }
    </style>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="content-header mb-3">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0">الخدمات الطبية</h5>

            <a href="<?php echo e(route('services.create')); ?>" class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i> إضافة خدمة جديدة
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-12">

            <div class="card table-card">
                <div class="card-header">
                    <h6 class="mb-0">قائمة الخدمات</h6>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table" id="pc-dt-simple">
                            <thead>
                            <tr>
                                <th class="text-start">#</th>
                                <th class="text-start">اسم الخدمة</th>
                                <th class="text-start">التخصص</th>
                                <th class="text-start">العيادة</th>
                                <th class="text-start">التصنيف</th>
                                <th class="text-start">السعر الافتراضي</th>
                                <th class="text-start">المدة (دقيقة)</th>
                                <th class="text-start">الحالة</th>
                                <th class="text-center">العمليات</th>
                            </tr>
                            </thead>

                            <tbody>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($service->id); ?></td>

                                    <td><?php echo e($service->name); ?></td>

                                    <td><?php echo e($service->specialty?->name ?? '-'); ?></td>

                                    <td><?php echo e($service->clinic?->name ?? '-'); ?></td>

                                    <td><?php echo e($service->category ?? '-'); ?></td>

                                    <td>
                                        <?php echo e(number_format($service->default_price, 2)); ?>

                                        <small class="text-muted"> <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="20" height="20" alt=""></small>
                                    </td>

                                    <td>
                                        <?php echo e($service->duration_minutes ? $service->duration_minutes . ' دقيقة' : '-'); ?>

                                    </td>

                                    <td class="text-center">
                                        <label class="switch">
                                            <input type="checkbox"
                                                   class="toggle-status"
                                                   data-id="<?php echo e($service->id); ?>"
                                                <?php echo e($service->is_active ? 'checked' : ''); ?>>
                                            <span class="slider round"></span>
                                        </label>
                                    </td>


                                    <td class="text-center">

                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="<?php echo e(route('services.edit', $service->id)); ?>"
                                               class="btn  btn-sm btn-success">
                                                <i class="fa fa-edit"></i>
                                            </a>

                                            <form action="<?php echo e(route('services.destroy', $service->id)); ?>"
                                                  method="POST"
                                                  onsubmit="return confirm('هل أنت متأكد من حذف هذه الخدمة؟');">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-sm btn-danger">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center text-muted">
                                        لا توجد خدمات مسجلة حتى الآن.
                                    </td>
                                </tr>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script>
        $(document).on('change', '.toggle-status', function () {
            let id = $(this).data('id');

            $.ajax({
                url: "<?php echo e(url('/services/toggle-status')); ?>/" + id,
                type: 'POST',
                data: {
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                success: function (res) {
                    toastr.success("تم تحديث حالة الخدمة إلى: " + res.status, "نجاح");
                },
                error: function () {
                    toastr.error("حدث خطأ، حاول مرة أخرى", "خطأ");
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\jops\SassMedical\resources\views/admin/services/index.blade.php ENDPATH**/ ?>