<?php $__env->startSection('title'); ?>
    <?php echo e($item->exists ? 'تعديل صنف بالمخزون' : 'إضافة صنف جديد للمخزون'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="content-header d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">
            <?php echo e($item->exists ? 'تعديل صنف بالمخزون' : 'إضافة صنف جديد للمخزون'); ?>

        </h5>

        <a href="<?php echo e(route('inventory.items.index')); ?>" class="btn btn-sm btn-outline-secondary">
            رجوع لقائمة المخزون
        </a>
    </div>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <strong>من فضلك صحح الأخطاء التالية:</strong>
            <ul class="mb-0">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $err): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($err); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </ul>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <form action="<?php echo e($item->exists
        ? route('inventory.items.update', $item->id)
        : route('inventory.items.store')); ?>"
          method="POST">
        <?php echo csrf_field(); ?>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->exists): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <div class="card">
            <div class="card-header">
                <h6 class="mb-0">بيانات الصنف</h6>
            </div>

            <div class="card-body">
                <div class="row g-3">

                    <div class="col-md-4">
                        <label class="form-label">اسم الصنف *</label>
                        <input type="text"
                               name="name"
                               class="form-control"
                               required
                               value="<?php echo e(old('name', $item->name)); ?>">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">التصنيف</label>
                        <select name="category" class="form-select">
                            <?php
                                $category = old('category', $item->category);
                            ?>
                            <option value="">بدون</option>
                            <option value="consumable" <?php echo e($category == 'consumable' ? 'selected' : ''); ?>>مستهلكات</option>
                            <option value="equipment"  <?php echo e($category == 'equipment'  ? 'selected' : ''); ?>>معدات</option>
                            <option value="medication" <?php echo e($category == 'medication' ? 'selected' : ''); ?>>أدوية</option>
                            <option value="other"      <?php echo e($category == 'other'      ? 'selected' : ''); ?>>أخرى</option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">الوحدة</label>
                        <input type="text"
                               name="unit"
                               class="form-control"
                               placeholder="مثال: علبة، قطعة، مل، جرام..."
                               value="<?php echo e(old('unit', $item->unit)); ?>">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">SKU / الكود الداخلي</label>
                        <input type="text"
                               name="sku"
                               class="form-control"
                               value="<?php echo e(old('sku', $item->sku)); ?>">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">الحد الأدنى للكمية *</label>
                        <input type="number" min="0"
                               name="min_quantity"
                               class="form-control"
                               value="<?php echo e(old('min_quantity', $item->min_quantity ?? 0)); ?>">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">الكمية الحالية *</label>
                        <input type="number" min="0"
                               name="current_quantity"
                               class="form-control"
                               value="<?php echo e(old('current_quantity', $item->current_quantity ?? 0)); ?>">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">سعر الشراء للوحدة *</label>
                        <div class="input-group">
                            <input type="number" min="0" step="0.01"
                                   name="purchase_price"
                                   class="form-control"
                                   value="<?php echo e(old('purchase_price', $item->purchase_price ?? 0)); ?>">
                            <span class="input-group-text">
                                <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="16" height="16" alt="">
                            </span>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">سعر البيع (اختياري)</label>
                        <div class="input-group">
                            <input type="number" min="0" step="0.01"
                                   name="sale_price"
                                   class="form-control"
                                   value="<?php echo e(old('sale_price', $item->sale_price ?? 0)); ?>">
                            <span class="input-group-text">
                                <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="16" height="16" alt="">
                            </span>
                        </div>
                    </div>

                </div>
            </div>

            <div class="card-footer text-end">
                <button type="submit" class="btn btn-primary">
                    <?php echo e($item->exists ? 'تحديث بيانات الصنف' : 'حفظ الصنف في المخزون'); ?>

                </button>
            </div>
        </div>
    </form>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\jops\SassMedical\resources\views/admin/inventory/form.blade.php ENDPATH**/ ?>