<?php $__env->startSection('title', 'تعديل مستخدم'); ?>

<?php $__env->startSection('content'); ?>

<div class="content-header d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">تعديل المستخدم: <?php echo e($user->name); ?></h5>

    <a href="<?php echo e(route('settings.users.index')); ?>" class="btn btn-sm btn-secondary">
        رجوع لقائمة المستخدمين
    </a>
</div>

<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
<div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($errors->any()): ?>
<div class="alert alert-danger">
    <strong>من فضلك صحح الأخطاء التالية:</strong>
    <ul class="mb-0">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $err): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li><?php echo e($err); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </ul>
</div>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

<form action="<?php echo e(route('settings.users.update', $user->id)); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>

    <div class="card">
        <div class="card-body">

            <div class="row g-3">

                <div class="col-md-4">
                    <label class="form-label">الاسم *</label>
                    <input type="text" name="name" class="form-control" value="<?php echo e($user->name); ?>" required>
                </div>

                <div class="col-md-4">
                    <label class="form-label">البريد *</label>
                    <input type="email" name="email" class="form-control" value="<?php echo e($user->email); ?>" required>
                </div>

                <div class="col-md-4">
                    <label class="form-label">الهاتف</label>
                    <input type="text" name="phone" value="<?php echo e($user->phone); ?>" class="form-control">
                </div>

                <div class="col-md-4">
                    <label class="form-label">الفرع</label>
                    <select name="branch_id" class="form-select">
                        <option value="">اختر فرع</option>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($b->id); ?>" <?php echo e($b->id == $user->branch_id ? 'selected' : null); ?>><?php echo e($b->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </select>
                </div>

                <div class="col-md-4">
                    <label class="form-label">نوع المستخدم *</label>
                    <select name="role" class="form-select" required>
                        <option value="owner" <?php echo e($user->role == "owner" ? 'selected': null); ?>>Owner</option>
                        <option value="admin" <?php echo e($user->role == "admin" ? 'selected': null); ?>>Admin</option>
                        <option value="doctor" <?php echo e($user->role == "doctor" ? 'selected': null); ?>>Doctor</option>
                        <option value="receptionist" <?php echo e($user->role == "receptionist" ? 'selected': null); ?>>Receptionist</option>
                        <option value="accountant" <?php echo e($user->role == "accountant" ? 'selected': null); ?>>Accountant</option>
                        <option value="nurse" <?php echo e($user->role == "nurse" ? 'selected': null); ?>>Nurse</option>
                    </select>
                </div>

                <div class="col-md-4">
                    <label class="form-label">كلمة المرور *</label>
                    <input type="password" name="password" class="form-control" >
                </div>

            </div>

        </div>
        <div class="card-footer text-end">
            <button class="btn btn-primary">حفظ</button>
        </div>
    </div>


</form>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    document.getElementById('btn-select-all').addEventListener('click', function () {
        document.querySelectorAll('.permission-checkbox').forEach(function (cb) {
            cb.checked = true;
        });
    });

    document.getElementById('btn-unselect-all').addEventListener('click', function () {
        document.querySelectorAll('.permission-checkbox').forEach(function (cb) {
            cb.checked = false;
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\jops\SassMedical\resources\views/admin/users/edit.blade.php ENDPATH**/ ?>