@extends('admin.layouts.master')

@section('title', 'المستخدمون والصلاحيات')

@section('content')

    <div class="content-header d-flex justify-content-between align-items-center mb-3">
        <h5>المستخدمون</h5>
        <a href="{{ route('settings.users.create') }}" class="btn btn-success btn-sm">إضافة مستخدم</a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="card">
        <div class="card-body table-responsive">
            <table class="table" id="pc-dt-simple">
                <thead>
                <tr>
                    <th>#</th>
                    <th>الاسم</th>
                    <th>البريد</th>
                    <th>الهاتف</th>
                    <th>الوظيفة</th>
                    <th>الفرع</th>
                    <th>الحالة</th>
                    <th>إجراءات</th>
                </tr>
                </thead>
                <tbody>

                @foreach($users as $u)
                    <tr>
                        <td>{{ $u->id }}</td>
                        <td>{{ $u->name }}</td>
                        <td>{{ $u->email }}</td>
                        <td>{{ $u->phone }}</td>
                        <td>{{ strtoupper($u->role) }}</td>
                        <td>{{ optional($u->branch)->name ?? '-' }}</td>

                        <td>
                            @if($u->is_active)
                                <span class="badge bg-success">نشط</span>
                            @else
                                <span class="badge bg-danger">معطل</span>
                            @endif
                        </td>

                        <td>
                            <a href="{{ route('settings.users.edit', $u->id) }}"
                               class="btn btn-primary btn-sm">تعديل</a>

                            <form action="{{ route('settings.users.toggle', $u->id) }}"
                                  method="POST" class="d-inline">
                                @csrf
                                <button class="btn btn-warning btn-sm">تبديل الحالة</button>
                            </form>

                            <form action="{{ route('settings.users.destroy', $u->id) }}"
                                  method="POST" class="d-inline"
                                  onsubmit="return confirm('هل تريد حذف المستخدم؟');">
                                @csrf @method('DELETE')
                                <button class="btn btn-danger btn-sm">حذف</button>
                            </form>
                        </td>
                    </tr>
                @endforeach

                </tbody>
            </table>

            {{ $users->links() }}
        </div>
    </div>

@endsection
