@extends('admin.layouts.master')

@section('title', 'إضافة خطة علاج جديدة')

@section('content')

    <div class="content-header mb-3">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0">إضافة خطة علاج للمريض: {{ $patient->first_name }} {{ $patient->last_name }}</h5>

            <a href="{{ route('patients.show', $patient->id) }}" class="btn btn-sm btn-secondary">
                رجوع لملف المريض
            </a>
        </div>
    </div>

    @if($errors->any())
        <div class="alert alert-danger">
            من فضلك صحح الأخطاء التالية:
            <ul class="mb-0">
                @foreach($errors->all() as $err)
                    <li>{{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="row gy-3">
        <div class="col-lg-8 col-12">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">بيانات خطة العلاج</h6>
                </div>
                <div class="card-body">

                    <form action="{{ route('treatment-plans.store') }}" method="POST">
                        @csrf

                        <input type="hidden" name="patient_id" value="{{ $patient->id }}">

                        {{-- الطبيب --}}
                        <div class="mb-3">
                            <label class="form-label">الطبيب المسؤول <span class="text-danger">*</span></label>
                            <select name="doctor_id"
                                    class="form-select @error('doctor_id') is-invalid @enderror"
                                    required>
                                <option value="">اختر الطبيب</option>
                                @foreach($doctors as $doctor)
                                    <option value="{{ $doctor->id }}"
                                        {{ old('doctor_id') == $doctor->id ? 'selected' : '' }}>
                                        {{ $doctor->user?->name }}
                                        @if($doctor->specialty?->name)
                                            ( {{ $doctor->specialty->name }} )
                                        @endif
                                    </option>
                                @endforeach
                            </select>
                            @error('doctor_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- العنوان --}}
                        <div class="mb-3">
                            <label class="form-label">عنوان الخطة (اختياري)</label>
                            <input type="text" name="title"
                                   class="form-control @error('title') is-invalid @enderror"
                                   value="{{ old('title') }}"
                                   placeholder="مثال: خطة علاج كاملة للأسنان العلوية">
                            @error('title')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- الوصف --}}
                        <div class="mb-3">
                            <label class="form-label">وصف / ملاحظات الخطة (اختياري)</label>
                            <textarea name="description"
                                      class="form-control @error('description') is-invalid @enderror"
                                      rows="4"
                                      placeholder="وصف عام لخطة العلاج، الأهداف، الملاحظات المهمة...">{{ old('description') }}</textarea>
                            @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- الحالة (مسودة / جارية) --}}
                        <div class="mb-3">
                            <label class="form-label d-block">حالة الخطة</label>
                            <select name="status" class="form-select">
                                <option value="draft" {{ old('status', 'draft') == 'draft' ? 'selected' : '' }}>
                                    مسودة
                                </option>
                                <option value="ongoing" {{ old('status') == 'ongoing' ? 'selected' : '' }}>
                                    جارية
                                </option>
                                <option value="completed" {{ old('status') == 'completed' ? 'selected' : '' }}>
                                    مكتملة
                                </option>
                                <option value="cancelled" {{ old('status') == 'cancelled' ? 'selected' : '' }}>
                                    ملغاة
                                </option>
                            </select>
                        </div>

                        <div class="mt-3">
                            <button type="submit" class="btn btn-primary">
                                حفظ خطة العلاج
                            </button>
                            <a href="{{ route('patients.show', $patient->id) }}" class="btn btn-light">
                                إلغاء
                            </a>
                        </div>

                    </form>

                </div>
            </div>
        </div>

        {{-- ملخص سريع للمريض على اليمين --}}
        <div class="col-lg-4 col-12">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">ملخص المريض</h6>
                </div>
                <div class="card-body">
                    <p class="mb-1"><strong>الاسم:</strong> {{ $patient->first_name }} {{ $patient->last_name }}</p>
                    <p class="mb-1"><strong>الكود:</strong> {{ $patient->code }}</p>
                    <p class="mb-1"><strong>الهاتف:</strong> {{ $patient->phone }}</p>
                    <p class="mb-1"><strong>العمر:</strong>
                        @if($patient->birth_date)
                            {{ \Carbon\Carbon::parse($patient->birth_date)->age }} سنة
                        @else
                            —
                        @endif
                    </p>
                    <p class="mb-0"><strong>العنوان:</strong> {{ $patient->address ?: '-' }}</p>
                </div>
            </div>
        </div>
    </div>

@endsection
