@extends('admin.layouts.master')
@section('css')

@endsection

@section('title')
    التخصصات
@endsection

@section('content')



    <div class="content-header">
        <h5>التخصصات</h5>

    </div>

    <div class="row">
        <div class="col-12">
            <div class="card table-card">
                <div class="card-header">
                    <a href="" class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#create">اضافه تخصص
                        جديد</a>
                    @include('admin.specialty.create')
                </div>
                <div class="card-body">
                    <!--begin::Table container-->
                    <div class="table-responsive">
                        <table class="table" id="pc-dt-simple">
                            <thead>
                            <tr>
                                <th class="text-start">الاسم</th>
                                <th class="text-start">إجمالي الدكاترة</th>
                                <th class="text-start">النشطين</th>
                                <th class="text-start">العمليات</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($data as $row)
                                <tr>
                                    <td>{{$row->name}}</td>
                                    <td>{{$row->doctorProfiles->count()}}</td>
                                    <td>{{$row->doctorProfiles->where('user.is_active', true)->count()}}</td>

                                    <td>
                                        <a href="{{ route('specialty.doctors', $row->id) }}"
                                           class="btn btn-info btn-sm">
                                            <i class="fa fa-user-md"></i> دكاترة التخصص
                                        </a>
                                        <button class="btn btn-success btn-sm"
                                                data-bs-toggle="modal"
                                                data-bs-target="#editModal{{ $row->id }}">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        @include('admin.specialty.edit')

                                        <form action="{{ route('specialty.destroy', $row->id) }}" method="POST"
                                              style="display:inline-block;"
                                              onsubmit="return confirm('هل انت متأكد من حذف هذا التخصص؟');">
                                            @csrf
                                            @method('DELETE')
                                            <button class="btn btn-danger btn-sm">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                        <!--end::Table-->
                    </div>
                    <!--end::Table container-->
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')

    <script>
        document.addEventListener("DOMContentLoaded", function () {

            let input = document.querySelector("input[name='name']");
            let btn   = document.getElementById("saveBtn");

            input.addEventListener("input", function () {
                if (this.value.trim().length > 0) {
                    btn.classList.remove("d-none");
                } else {
                    btn.classList.add("d-none");
                }
            });

        });
    </script>
@endsection
