@extends('admin.layouts.master')
@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
@endsection

@section('title', 'دكاترة تخصص: ' . $specialty->name)


@section('content')

    <div class="content-header mb-3">
        <div class="d-flex justify-content-between align-items-center">

            <h5 class="mb-0">
                دكاترة تخصص: {{ $specialty->name }}
            </h5>

            <div class="d-flex align-items-center gap-2">
                <a href="{{ route('doctors.create', ['specialty_id' => $specialty->id]) }}"
                   class="btn btn-sm btn-success">
                    إضافة دكتور لهذا التخصص
                </a>

                <a href="{{ route('specialty.index') }}"
                   class="btn btn-sm btn-info">
                    صفحة التخصصات
                </a>
            </div>

        </div>
    </div>


    <div class="card shadow-sm">
        <div class="card-body">

            @if($specialty->doctorProfiles->count())

                <div class="table-responsive">
                    <table class="table table-striped table-sm">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>اسم الدكتور</th>
                            <th>العيادة</th>
                            <th>الفرع</th>
                            <th>الجوال</th>
                            <th>الحالة</th>
                            <th>العمليات</th>
                        </tr>
                        </thead>

                        <tbody>
                        @foreach($specialty->doctorProfiles as $profile)
                            <tr>
                                <td>{{ $profile->id }}</td>
                                <td>{{ $profile->user->name }}</td>
                                <td>{{ $profile->user->clinic?->name ?? '-' }}</td>
                                <td>{{ $profile->branch?->name ?? '-' }}</td>
                                <td>{{ $profile->user->phone }}</td>
                                <td>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input doctor-status-switch"
                                               type="checkbox"
                                               id="doctorSwitch{{ $profile->user->id }}"
                                               data-id="{{ $profile->user->id }}"
                                            {{ $profile->user->is_active ? 'checked' : '' }}>

                                        <label class="form-check-label" for="doctorSwitch{{ $profile->user->id }}">
                                            {{ $profile->user->is_active ? 'نشط' : 'غير نشط' }}
                                        </label>
                                    </div>
                                </td>


                                <td>
                                    <a href="{{ route('doctors.show', $profile->user_id) }}" class="btn btn-sm btn-outline-info">
                                        عرض
                                    </a>
                                    <a href="{{ route('doctors.edit', $profile->user_id) }}" class="btn btn-sm btn-outline-primary">
                                        تعديل
                                    </a>

                                </td>

                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>

            @else
                <p class="text-center text-muted">
                    لا يوجد دكاترة مسجلين لهذا التخصص.
                </p>
            @endif

        </div>
    </div>

@endsection

@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {

            const switches = document.querySelectorAll('.doctor-status-switch');

            switches.forEach(function (sw) {
                sw.addEventListener('change', function () {
                    const userId = this.getAttribute('data-id');
                    const isActive = this.checked ? 1 : 0;
                    const label    = this.closest('.form-check').querySelector('.form-check-label');

                    fetch("{{ route('doctors.toggleStatus') }}", {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                            'Accept': 'application/json'
                        },
                        body: JSON.stringify({
                            id: userId,
                            is_active: isActive
                        })
                    })
                        .then(response => response.json())
                        .then(data => {
                            if (data.status === true) {
                                label.textContent = isActive ? 'نشط' : 'غير نشط';

                                if (window.toastr) {
                                    toastr.success(data.message || 'تم تحديث حالة الدكتور بنجاح');
                                }
                            } else {
                                sw.checked = !isActive;
                                label.textContent = !isActive ? 'نشط' : 'غير نشط';

                                if (window.toastr) {
                                    toastr.error(data.message || 'حدث خطأ أثناء تحديث الحالة');
                                }
                            }
                        })
                        .catch(err => {
                            sw.checked = !isActive;
                            label.textContent = !isActive ? 'نشط' : 'غير نشط';

                            if (window.toastr) {
                                toastr.error('تعذر الاتصال بالسيرفر');
                            }
                        });
                });
            });

        });
    </script>

@endsection
