@extends('admin.layouts.master')

@section('title', 'تعديل خدمة')

@section('content')

    <div class="content-header mb-3">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0">تعديل خدمة: {{ $service->name }}</h5>

            <a href="{{ route('services.index') }}" class="btn btn-sm btn-secondary">
                رجوع لقائمة الخدمات
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12 col-12">

            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">بيانات الخدمة</h6>
                </div>

                <div class="card-body">

                    <form action="{{ route('services.update', $service->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        {{-- clinic_id --}}
                        @if(auth()->user()->clinic_id)
                            <input type="hidden" name="clinic_id" value="{{ auth()->user()->clinic_id }}">
                        @endif

                        {{-- اسم الخدمة --}}
                        <div class="mb-3">
                            <label class="form-label">اسم الخدمة <span class="text-danger">*</span></label>
                            <input type="text" name="name"
                                   class="form-control @error('name') is-invalid @enderror"
                                   value="{{ old('name', $service->name) }}" required>
                            @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- التخصص --}}
                        <div class="mb-3">
                            <label class="form-label">التخصص <span class="text-danger">*</span></label>
                            <select name="specialty_id"
                                    class="form-select @error('specialty_id') is-invalid @enderror"
                                    required>
                                <option value="">اختر التخصص</option>
                                @foreach($specialties as $specialty)
                                    <option value="{{ $specialty->id }}"
                                        {{ old('specialty_id', $service->specialty_id) == $specialty->id ? 'selected' : '' }}>
                                        {{ $specialty->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('specialty_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- التصنيف (اختياري) --}}
                        <div class="mb-3">
                            <label class="form-label">تصنيف الخدمة (اختياري)</label>
                            <input type="text" name="category"
                                   class="form-control @error('category') is-invalid @enderror"
                                   value="{{ old('category', $service->category) }}"
                                   placeholder="مثال: كشف، استشارة، جلسة، عملية ...">
                            @error('category')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- السعر الافتراضي --}}
                        <div class="mb-3">
                            <label class="form-label">السعر الافتراضي <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="number" step="0.01" min="0"
                                       name="default_price"
                                       class="form-control @error('default_price') is-invalid @enderror"
                                       value="{{ old('default_price', $service->default_price) }}" required>
                                <span class="input-group-text">ريال</span>
                                @error('default_price')
                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        {{-- مدة الجلسة --}}
                        <div class="mb-3">
                            <label class="form-label">المدة (بالدقائق)</label>
                            <input type="number" min="0"
                                   name="duration_minutes"
                                   class="form-control @error('duration_minutes') is-invalid @enderror"
                                   value="{{ old('duration_minutes', $service->duration_minutes) }}"
                                   placeholder="مثال: 30، 45، 60">
                            @error('duration_minutes')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- الحالة --}}
                        <div class="mb-3">
                            <label class="form-label d-block">حالة الخدمة</label>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox"
                                       id="is_active" name="is_active"
                                       value="1"
                                    {{ old('is_active', $service->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    الخدمة نشطة ومتاحة للاستخدام
                                </label>
                            </div>
                        </div>

                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">
                                حفظ التعديلات
                            </button>
                            <a href="{{ route('services.index') }}" class="btn btn-light">
                                إلغاء
                            </a>
                        </div>

                    </form>

                </div>
            </div>

        </div>
    </div>

@endsection
