<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <title>طباعة روشتة #{{ $prescription->id }}</title>

    <style>
        body {
            font-family: "Cairo", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            direction: rtl;
            margin: 20px;
            color: #333;
        }

        .prescription-wrapper {
            max-width: 800px;
            margin: 0 auto;
            border: 1px solid #ccc;
            padding: 20px 25px;
            border-radius: 8px;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 20px;
        }

        .clinic-info h2 {
            margin: 0;
            font-size: 22px;
        }

        .clinic-info small {
            display: block;
            color: #777;
        }

        .rx-title {
            text-align: center;
            margin: 15px 0 20px;
            font-size: 22px;
            font-weight: bold;
            text-decoration: underline;
        }

        .patient-info,
        .doctor-info {
            margin-bottom: 10px;
        }

        .patient-info span,
        .doctor-info span {
            display: inline-block;
            margin-inline-end: 20px;
        }

        .rx-content {
            margin-top: 20px;
            min-height: 250px;
            line-height: 1.8;
            font-size: 15px;
            white-space: pre-wrap;
        }

        .rx-footer {
            margin-top: 30px;
            display: flex;
            justify-content: space-between;
        }

        .sign-box {
            width: 45%;
            text-align: center;
        }

        .sign-box .label {
            font-weight: bold;
            margin-bottom: 60px;
        }

        .rx-meta {
            font-size: 13px;
            color: #777;
            margin-top: 10px;
        }

        .meds-list {
            margin-top: 15px;
        }

        .meds-list h4 {
            margin-bottom: 8px;
        }

        .meds-list ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .meds-list li {
            padding: 6px 0;
            border-bottom: 1px dashed #ccc;
        }

        .no-print {
            margin-bottom: 15px;
            text-align: left;
        }

        .no-print button {
            padding: 6px 12px;
            font-size: 14px;
            cursor: pointer;
        }

        @media print {
            .no-print {
                display: none;
            }

            body {
                margin: 0;
            }

            .prescription-wrapper {
                border: none;
                border-radius: 0;
                padding: 10mm 13mm;
            }
        }
    </style>
</head>
<body>

<div class="no-print">
    <button onclick="window.print()">طباعة</button>
</div>

<div class="prescription-wrapper">

    <div class="header">
        <div class="clinic-info">
            <h2>{{ $prescription->doctor?->user?->clinic?->name ?? 'اسم العيادة' }}</h2>
            <small>
                د. {{ $prescription->doctor?->user?->name ?? '' }}

            </small>
            <small>
                الهاتف:
                {{ $prescription->doctor?->user?->phone ?? $prescription->patient?->clinic?->phone ?? '' }}
            </small>
        </div>

        <div class="logo">
            {{-- لو عندك لوجو --}}
            {{-- <img src="{{ asset('path/to/logo.png') }}" alt="Logo" height="70"> --}}
        </div>
    </div>

    <div class="rx-title">
        روشتة طبية
    </div>

    <div class="patient-info">
        <span><strong>المريض:</strong> {{ $prescription->patient?->first_name }} {{ $prescription->patient?->last_name }}</span>
        <span><strong>السن:</strong>
            @if($prescription->patient?->birth_date)
                {{ \Carbon\Carbon::parse($prescription->patient->birth_date)->age }} سنة
            @else
                —
            @endif
        </span>
    </div>

    <div class="doctor-info">
        <span><strong>الطبيب:</strong> د. {{ $prescription->doctor?->user?->name }}</span>

        <span><strong>التخصص:</strong>  {{ $prescription->doctor->specialty->name }}</span>
        <span><strong>التاريخ:</strong> {{ $prescription->created_at->format('Y-m-d') }}</span>
    </div>

    <div class="rx-meta">
        رقم الروشتة: #{{ $prescription->id }}
        @if($prescription->visit_id)
            — مرتبطة بزيارة رقم {{ $prescription->visit_id }}
        @endif
    </div>

    <div class="rx-content">
        {!! $prescription->notes !!}
    </div>

{{--    @if($prescription->items && $prescription->items->count())--}}
{{--        <div class="meds-list">--}}
{{--            <h4>الأدوية:</h4>--}}
{{--            <ul>--}}
{{--                @foreach($prescription->items as $item)--}}
{{--                    <li>--}}
{{--                        <strong>{{ $item->medication->name ?? '—' }}</strong><br>--}}
{{--                        <small>{!!   $item->instructions !!}</small>--}}
{{--                    </li>--}}
{{--                @endforeach--}}
{{--            </ul>--}}
{{--        </div>--}}
{{--    @endif--}}

    <div class="rx-footer">
        <div class="sign-box">
            <div class="label">توقيع الطبيب</div>
            <div>__________________________</div>
        </div>
        <div class="sign-box">
            <div class="label">توقيع المريض</div>
            <div>__________________________</div>
        </div>
    </div>

</div>

<script>
    window.onload = function () {
        window.print();
    };
</script>

</body>
</html>
