@php
    use App\Helpers\RoleHelper;
@endphp

<aside class="app-sidebar app-light-sidebar" dir="rtl">
    <div class="app-navbar-wrapper">

        {{-- Logo --}}
        <div class="brand-link brand-logo">
            <a href="{{ route('dashboard.index') }}" class="b-brand">
                <img src="{{ asset('dash/assets/images/logo-dark.svg') }}" alt="Logo" class="logo logo-lg">
            </a>
        </div>

        <div class="navbar-content">
            <ul class="app-navbar">

                {{-- ------------------------------
                      Dashboard
                ------------------------------- --}}
                <li class="nav-item nav-hasmenu {{ request()->routeIs('dashboard.*') ? 'active' : '' }}">
                    <a href="#" class="nav-link">
                        <span class="nav-icon"><i class="ti ti-layout-2"></i></span>
                        <span class="nav-text">الصفحة الرئيسية</span>
                        <span class="nav-arrow"><i data-feather="chevron-left"></i></span>
                    </a>
                    <ul class="nav-submenu">
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('dashboard.index') ? 'active' : '' }}"
                               href="{{ route('dashboard.index') }}">
                                لوحة التحكم
                            </a>
                        </li>
                    </ul>
                </li>


                {{-- ------------------------------
                       Clinic Management Title
                ------------------------------ --}}
                <li class="nav-item nav-caption">
                    <label>إدارة العيادة</label>
                </li>


                {{-- ------------------------------
                       Patients
                ------------------------------ --}}
                @if(RoleHelper::canSeePatients())
                    <li class="nav-item {{ request()->routeIs('patients.*') ? 'active' : '' }}">
                        <a href="{{ route('patients.index') }}" class="nav-link">
                            <span class="nav-icon"><i class="ti ti-users"></i></span>
                            <span class="nav-text">المرضى</span>
                        </a>
                    </li>
                @endif


                {{-- ------------------------------
                       Doctors (Owner + Admin + Doctor)
                ------------------------------ --}}
                @if(RoleHelper::canSeeDoctors())
                    <li class="nav-item {{ request()->routeIs('doctors.*') ? 'active' : '' }}">
                        <a href="{{ route('doctors.index') }}" class="nav-link">
                            <span class="nav-icon"><i class="fa fa-user-md"></i></span>
                            <span class="nav-text">الأطباء</span>
                        </a>
                    </li>
                @endif


                {{-- ------------------------------
                       Services & Treatments
                ------------------------------ --}}
                @if(RoleHelper::canSeePatients())
                    <li class="nav-item nav-hasmenu
                        {{ request()->routeIs('services.*') || request()->routeIs('specialty.*') || request()->routeIs('treatment-plans.*') ? 'active nav-provoke' : '' }}">

                        <a href="#" class="nav-link">
                            <span class="nav-icon"><i class="fa fa-clipboard-check"></i></span>
                            <span class="nav-text">العلاجات والخدمات</span>
                            <span class="nav-arrow"><i data-feather="chevron-left"></i></span>
                        </a>

                        <ul class="nav-submenu">

                            <li class="nav-item {{ request()->routeIs('specialty.*') ? 'active' : '' }}">
                                <a class="nav-link" href="{{ route('specialty.index') }}">
                                    التخصصات الطبية
                                </a>
                            </li>

                            <li class="nav-item {{ request()->routeIs('services.*') ? 'active' : '' }}">
                                <a class="nav-link" href="{{ route('services.index') }}">
                                    الخدمات الطبية
                                </a>
                            </li>

                            <li class="nav-item {{ request()->routeIs('treatment-plans.*') ? 'active' : '' }}">
                                <a class="nav-link" href="{{ route('treatment-plans.index') }}">
                                    خطط العلاج
                                </a>
                            </li>

                        </ul>

                    </li>
                @endif


                {{-- ------------------------------
                       Invoices
                ------------------------------ --}}
                @if(RoleHelper::canSeeInvoices())
                    <li class="nav-item nav-hasmenu {{ request()->routeIs('invoices.*') ? 'active nav-provoke' : '' }}">
                        <a href="#" class="nav-link">
                            <span class="nav-icon"><i class="ti ti-receipt-2"></i></span>
                            <span class="nav-text">الفواتير والمالية</span>
                            <span class="nav-arrow"><i data-feather="chevron-left"></i></span>
                        </a>

                        <ul class="nav-submenu">
                            <li class="nav-item {{ request()->routeIs('invoices.*') ? 'active' : '' }}">
                                <a class="nav-link" href="{{ route('invoices.index') }}">
                                    الفواتير
                                </a>
                            </li>
                        </ul>
                    </li>
                @endif


                {{-- ------------------------------
                       Inventory (Owner + Admin)
                ------------------------------ --}}
                @if(RoleHelper::canSeeInventory())
                    <li class="nav-item nav-hasmenu {{ request()->routeIs('inventory.*') ? 'active nav-provoke' : '' }}">
                        <a href="#" class="nav-link">
                            <span class="nav-icon"><i class="ti ti-box"></i></span>
                            <span class="nav-text">المخزون والصيدلية</span>
                            <span class="nav-arrow"><i data-feather="chevron-left"></i></span>
                        </a>

                        <ul class="nav-submenu">

                            <li class="nav-item {{ request()->routeIs('inventory.items.*') ? 'active' : '' }}">
                                <a class="nav-link" href="{{ route('inventory.items.index') }}">
                                    الأصناف
                                </a>
                            </li>

                            <li class="nav-item {{ request()->routeIs('inventory.movements.*') ? 'active' : '' }}">
                                <a class="nav-link" href="{{ route('inventory.movements.index') }}">
                                    حركات المخزون
                                </a>
                            </li>

                        </ul>
                    </li>
                @endif


                {{-- ------------------------------
                       System Settings (Owner + Admin)
                ------------------------------ --}}
                @if(RoleHelper::canSeeSettings())
                    <li class="nav-item nav-caption">
                        <label>إعدادات النظام</label>
                    </li>

                    <li class="nav-item nav-hasmenu {{ request()->routeIs('settings.*') ? 'active nav-provoke' : '' }}">
                        <a href="#" class="nav-link">
                            <span class="nav-icon"><i class="ti ti-settings"></i></span>
                            <span class="nav-text">الإعدادات</span>
                            <span class="nav-arrow"><i data-feather="chevron-left"></i></span>
                        </a>

                        <ul class="nav-submenu">

                            <li class="nav-item {{ request()->routeIs('settings.users.*') ? 'active' : '' }}">
                                <a class="nav-link" href="{{ route('settings.users.index') }}">
                                    المستخدمون والصلاحيات
                                </a>
                            </li>

                            <li class="nav-item {{ request()->routeIs('settings.clinic.*') ? 'active' : '' }}">
                                <a class="nav-link" href="{{ route('settings.clinic.index') }}">
                                    بيانات العيادة
                                </a>
                            </li>

                        </ul>
                    </li>
                @endif

            </ul>
        </div>

    </div>
</aside>
