@extends('admin.layouts.master')

@section('title', 'حركات المخزون')

@section('content')

    <div class="content-header d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">حركات المخزون</h5>

        <a href="{{ route('inventory.items.index') }}" class="btn btn-sm btn-outline-secondary">
            الرجوع للمخزون
        </a>
    </div>

    {{-- فلاتر بسيطة --}}
    <div class="card mb-3">
        <div class="card-header">
            <h6 class="mb-0">تصفية النتائج</h6>
        </div>
        <div class="card-body">
            <form method="GET" class="row gy-2 gx-2">

                <div class="col-md-4">
                    <label class="form-label">الصنف</label>
                    <select name="inventory_item_id" class="form-select">
                        <option value="">الكل</option>
                        @foreach($items as $item)
                            <option value="{{ $item->id }}"
                                {{ request('inventory_item_id') == $item->id ? 'selected' : '' }}>
                                {{ $item->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-2">
                    <label class="form-label">النوع</label>
                    <select name="type" class="form-select">
                        <option value="">الكل</option>
                        <option value="in" {{ request('type') == 'in' ? 'selected' : '' }}>دخول</option>
                        <option value="out" {{ request('type') == 'out' ? 'selected' : '' }}>خروج</option>
                        <option value="adjustment" {{ request('type') == 'adjustment' ? 'selected' : '' }}>تعديل</option>
                    </select>
                </div>

                <div class="col-md-2">
                    <label class="form-label">من تاريخ</label>
                    <input type="date" name="date_from" class="form-control"
                           value="{{ request('date_from') }}">
                </div>

                <div class="col-md-2">
                    <label class="form-label">إلى تاريخ</label>
                    <input type="date" name="date_to" class="form-control"
                           value="{{ request('date_to') }}">
                </div>

                <div class="col-md-2 d-flex align-items-end">
                    <button class="btn btn-primary w-100">
                        بحث
                    </button>
                </div>
            </form>
        </div>
    </div>

    {{-- جدول الحركات --}}
    <div class="card">
        <div class="card-header">
            <h6 class="mb-0">قائمة الحركات</h6>
        </div>

        <div class="card-body">
            @if($movements->count())
                <div class="table-responsive">
                    <table class="table table-striped align-middle">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>التاريخ</th>
                            <th>الصنف</th>
                            <th>النوع</th>
                            <th>الكمية</th>
                            <th>السبب</th>
                            <th>مرجع</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($movements as $mv)
                            <tr>
                                <td>{{ $mv->id }}</td>
                                <td>{{ $mv->created_at->format('Y-m-d H:i') }}</td>
                                <td>{{ $mv->inventoryItem?->name ?? '-' }}</td>
                                <td>
                                    @if($mv->type === 'in')
                                        <span class="badge bg-success">دخول</span>
                                    @elseif($mv->type === 'out')
                                        <span class="badge bg-danger">خروج</span>
                                    @else
                                        <span class="badge bg-warning text-dark">تعديل</span>
                                    @endif
                                </td>
                                <td>{{ $mv->quantity }}</td>
                                <td>{{ $mv->reason ?: '-' }}</td>
                                <td>
                                    @if($mv->reference_type && $mv->reference_id)
                                        {{ $mv->reference_type }} #{{ $mv->reference_id }}
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="mt-3">
                    {{ $movements->appends(request()->query())->links() }}
                </div>
            @else
                <p class="text-center text-muted mb-0">
                    لا توجد حركات مخزون مطابقة للبحث.
                </p>
            @endif
        </div>
    </div>

@endsection
