@extends('admin.layouts.master')
@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

@endsection

@section('title')
    الأطباء
@endsection

@section('content')

    <div class="content-header">
        <h5>الأطباء</h5>

    </div>

    <div class="row">
        <div class="col-12">
            <div class="card table-card">
                <div class="card-header">
                    <a href="{{route('doctors.create')}}" class="btn btn-sm btn-success">اضافه طبيب جديد</a>
                </div>
                <div class="card-body">
                    <!--begin::Table container-->
                    <div class="table-responsive">
                        <!--begin::Table-->
                        <table class="table table-striped table-row-bordered gy-5 gs-7" id="pc-dt-simple">
                            {!! $dataTable->table() !!}
                        </table>
                        <!--end::Table-->
                    </div>
                    <!--end::Table container-->
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    {!! $dataTable->scripts() !!}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script>
        $(document).on('change', '.toggle-status', function () {

            let doctorId = $(this).data('id');
            let newStatus = $(this).is(':checked') ? 1 : 0;

            $.ajax({
                url: "{{ route('doctors.toggleStatus') }}",
                method: "POST",
                data: {
                    _token: "{{ csrf_token() }}",
                    id: doctorId,
                    is_active: newStatus
                },
                success: function (response) {
                    toastr.success(response.message);
                },
                error: function () {
                    toastr.error("حدث خطأ، من فضلك حاول مرة أخرى");
                }
            });

        });
    </script>

@endsection
