@extends('admin.layouts.master')

@section('title', 'إعدادات العيادة')

@section('content')

    <div class="content-header mb-3">
        <h5>إعدادات العيادة</h5>
    </div>

    @if(session('success'))
        <div class="alert alert-success">
            ✔ {{ session('success') }}
        </div>
    @endif

    @if($errors->any())
        <div class="alert alert-danger">
            <strong>من فضلك صحح الأخطاء التالية:</strong>
            <ul class="mb-0">
                @foreach($errors->all() as $err)
                    <li>{{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card">
        <div class="card-header">
            <h6 class="mb-0">بيانات العيادة</h6>
        </div>

        <form action="{{ route('settings.clinic.update') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="card-body">
                <div class="row g-3">

                    {{-- اسم العيادة --}}
                    <div class="col-md-6">
                        <label class="form-label">اسم العيادة *</label>
                        <input type="text" name="name" class="form-control" required
                               value="{{ old('name', $clinic->name) }}">
                    </div>

                    {{-- اسم المالك --}}
                    <div class="col-md-6">
                        <label class="form-label">اسم المالك</label>
                        <input type="text" name="owner_name" class="form-control"
                               value="{{ old('owner_name', $clinic->owner_name) }}">
                    </div>

                    {{-- الهاتف --}}
                    <div class="col-md-4">
                        <label class="form-label">الهاتف</label>
                        <input type="text" name="phone" class="form-control"
                               value="{{ old('phone', $clinic->phone) }}">
                    </div>


                    {{-- الايميل --}}
                    <div class="col-md-4">
                        <label class="form-label">البريد الإلكتروني</label>
                        <input type="email" name="email" class="form-control"
                               value="{{ old('email', $clinic->email) }}">
                    </div>

                    {{-- العنوان --}}
                    <div class="col-md-12">
                        <label class="form-label">العنوان</label>
                        <textarea name="address" class="form-control" rows="2">{{ old('address', $clinic->address) }}</textarea>
                    </div>

                    {{-- الرقم الضريبي --}}
                    <div class="col-md-6">
                        <label class="form-label">الرقم الضريبي</label>
                        <input type="text" name="tax_number" class="form-control"
                               value="{{ old('tax_number', $clinic->tax_number) }}">
                    </div>




                </div>
            </div>

            <div class="card-footer text-end">
                <button class="btn btn-primary">حفظ التعديلات</button>
            </div>
        </form>
    </div>

@endsection
