<?php

namespace Database\Seeders;

use App\Models\DoctorProfiles;
use App\Models\Patients;
use App\Models\Prescriptions;
use App\Models\Visits;
use Illuminate\Database\Seeder;


class PrescriptionSeeder extends Seeder
{
    public function run(): void
    {
        Prescriptions::create([
            'visit_id'   => Visits::first()->id,
            'patient_id' => Patients::first()->id,
            'doctor_id'  => DoctorProfiles::first()->id,
            'notes'      => 'Take medications after meals and avoid cold drinks.',
        ]);
    }
}
