<?php

namespace Database\Seeders;

use App\Models\Invoices;
use App\Models\Payments;
use Illuminate\Database\Seeder;

class PaymentSeeder extends Seeder
{
    public function run(): void
    {
        $invoice = Invoices::first();

        Payments::create([
            'invoice_id'     => $invoice->id,
            'amount'         => 600,
            'payment_method' => 'cash',
            'transaction_id' => 'CASH-'.now()->timestamp,
            'paid_at'        => now()->subDay(),
            'notes'          => 'Down payment',
        ]);
    }
}
