<?php

namespace Database\Seeders;

use App\Models\Branches;
use App\Models\DoctorProfiles;
use App\Models\Patients;
use Illuminate\Database\Seeder;
use App\Models\Appointment;
use App\Models\Clinic;


class AppointmentSeeder extends Seeder
{
    public function run(): void
    {
        Appointment::create([
            'clinic_id' => Clinic::first()->id,
            'branch_id' => Branches::first()->id,
            'patient_id' => Patients::first()->id,
            'doctor_id' => DoctorProfiles::first()->id,
            'appointment_date' => now()->format('Y-m-d'),
            'start_time' => '13:00',
            'status' => 'confirmed',
        ]);
    }
}
