<?php



namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ServiceInventoryItem extends Model
{
    protected $fillable = [
        'service_id',
        'inventory_item_id',
        'quantity_per_service',
    ];

    public function service()
    {
        return $this->belongsTo(Services::class, 'service_id');
    }

    public function inventoryItem()
    {
        return $this->belongsTo(InventoryItems::class, 'inventory_item_id');
    }
}
