<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Prescriptions extends Model
{
    use HasFactory;

    protected $fillable = [
        'visit_id',
        'patient_id',
        'doctor_id',
        'notes',
    ];

    public function visit()
    {
        return $this->belongsTo(Visits::class, 'visit_id');
    }

    public function patient()
    {
        return $this->belongsTo(Patients::class, 'patient_id');
    }

    public function doctor()
    {
        return $this->belongsTo(DoctorProfiles::class, 'doctor_id');
    }

    public function items()
    {
        return $this->hasMany(PrescriptionItems::class, 'prescription_id');
    }
}
