<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Medications extends Model
{
    use HasFactory;

    protected $fillable = [
        'clinic_id',
        'name',
        'generic_name',
        'form',
        'strength',
    ];

    public function clinic()
    {
        return $this->belongsTo(Clinic::class, 'clinic_id');
    }

    public function prescriptionItems()
    {
        return $this->hasMany(PrescriptionItems::class, 'medication_id');
    }
}
