<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;


class Clinic extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'trade_name',
        'owner_name',
        'country',
        'city',
        'address',
        'phone',
        'email',
        'tax_number',
        'logo_path',
        'is_active',
    ];

    public function branches()
    {
        return $this->hasMany(Branches::class, 'clinic_id');
    }

    public function users()
    {
        return $this->hasMany(User::class, 'clinic_id');
    }

    public function patients()
    {
        return $this->hasMany(Patients::class, 'clinic_id');
    }

    public function services()
    {
        return $this->hasMany(Services::class, 'clinic_id');
    }

    public function inventoryItems()
    {
        return $this->hasMany(InventoryItems::class, 'clinic_id');
    }

    public function settings()
    {
        return $this->hasMany(Settings::class, 'clinic_id');
    }

    public function invoices()
    {
        return $this->hasMany(Invoices::class, 'clinic_id');
    }

    public function activityLogs()
    {
        return $this->hasMany(ActivityLogs::class, 'clinic_id');
    }
}
