<?php

namespace App\Http\Controllers\Setting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class ClinicSettingController extends Controller
{
    public function index()
    {
        $clinic = Auth::user()->clinic;

        if (!$clinic) {
            abort(404, 'بيانات العيادة غير موجودة');
        }

        return view('admin.clinic.index', compact('clinic'));
    }


    public function update(Request $request)
    {
        $clinic = Auth::user()->clinic;

        if (!$clinic) {
            abort(404, 'بيانات العيادة غير موجودة');
        }

        $request->validate([
            'name'         => 'required|string|max:255',
            'owner_name'   => 'nullable|string|max:255',
            'phone'        => 'nullable|string|max:50',

            'email'        => 'nullable|email|max:255',
            'address'      => 'nullable|string|max:500',
            'tax_number'   => 'nullable|string|max:100',

            'logo'         => 'nullable|image|mimes:png,jpg,jpeg,webp|max:2048',
        ]);

//        // رفع الشعار
//        if ($request->hasFile('logo')) {
//            if ($clinic->logo && Storage::disk('public')->exists($clinic->logo)) {
//                Storage::disk('public')->delete($clinic->logo);
//            }
//
//            $path = $request->file('logo')->store('clinic/logo', 'public');
//            $clinic->logo = $path;
//        }

        $clinic->name               = $request->name;
        $clinic->owner_name         = $request->owner_name;
        $clinic->phone              = $request->phone;

        $clinic->email              = $request->email;
        $clinic->address            = $request->address;
        $clinic->tax_number         = $request->tax_number;


        $clinic->save();

        return back()->with('success', 'تم تحديث بيانات العيادة بنجاح');
    }
}
